//
// Copyright (C) 2020 Guido Berhoerster <guido+ordertracker@berhoerster.name>
//

// +build !devel

package ordertracker

import (
	"golang.org/x/tools/godoc/vfs/httpfs"
	"golang.org/x/tools/godoc/vfs/mapfs"
	"net/http"
)

type StaticHandler struct {
	ot *OrderTracker
}

func NewStaticHandler(ot *OrderTracker) *StaticHandler {
	return &StaticHandler{ot: ot}
}

func (h *StaticHandler) ServeHTTP(w http.ResponseWriter, r *http.Request) {
	fs := httpfs.New(mapfs.New(StaticFiles))
	http.FileServer(fs).ServeHTTP(w, r)
}
